function CreateArmyTribalCamps()
	NVBaseDefArmies = {}
	for i = 1,5,1 do
		UACounter = UACounter + 1
		NVBaseDefArmies[i] = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 2800,
			AutoDestroyIfEmpty = true,
			TransitAttackMove = true,
			Formation = UnlimitedArmy.Formations.Chaotic,
			PrepDefense = false,
			DestroyBridges = false,
			LeaderFormation = nil,
			AIActive = true,
			DefendDoNotHelpHeroes = false,
			DoNotNormalizeSpeed = false,
			IgnoreFleeing = true,
			HiResJob = true
		},
		UACounter,
		UAMaxCounter
		)
		if i >= 4 then 
			local _spawn = {}
			if i == 4 then
				_spawn[1] = GetPosition("P2_Nephilim_TribalCamp4")
				_spawn[1].Generator = "Nephilim_Tribal_CampTower4"
				_spawn[2] = GetPosition("P2_Nephilim_TribalCamp4")
				_spawn[2].Generator = "Nephilim_Tribal_CampTower41"
				_spawn[3] = GetPosition("P2_Nephilim_TribalCamp4")
				_spawn[3].Generator = "Nephilim_Tribal_CampTower42"
				_spawn[4] = GetPosition("P2_Nephilim_TribalCamp4")
				_spawn[4].Generator = "Nephilim_Tribal_CampTower43"
				_spawn[5] = GetPosition("P2_Nephilim_TribalCamp4")
				_spawn[5].Generator = "Nephilim_Tribal_CampTower44"
				_spawn[6] = GetPosition("P2_Nephilim_TribalCamp4")
				_spawn[6].Generator = "Nephilim_Tribal_CampTower45"
			end
			if i == 5 then
				_spawn[1] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[1].Generator = "Nephilim_Tribal_CampTower5"
				_spawn[2] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[2].Generator = "Nephilim_Tribal_CampTower51"
				_spawn[3] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[3].Generator = "Nephilim_Tribal_CampTower52"
				_spawn[4] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[4].Generator = "Nephilim_Tribal_CampTower53"
				_spawn[5] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[5].Generator = "Nephilim_Tribal_CampTower54"
				_spawn[6] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[6].Generator = "Nephilim_Tribal_CampTower55"
				_spawn[7] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[7].Generator = "Nephilim_Tribal_CampTower56"
				_spawn[8] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[8].Generator = "Nephilim_Tribal_CampTower57"
				_spawn[9] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[9].Generator = "Nephilim_Tribal_CampTower58"
				_spawn[10] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[10].Generator = "Nephilim_Tribal_CampTower59"
				_spawn[11] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[11].Generator = "Nephilim_Tribal_CampTower510"
				_spawn[12] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[12].Generator = "Nephilim_Tribal_CampTower511"
				_spawn[13] = GetPosition("P2_Nephilim_TribalCamp5")
				_spawn[13].Generator = "Nephilim_Tribal_CampTower512"
			end
			UnlimitedArmySpawnGenerator:New(NVBaseDefArmies[i],{
				Position = _spawn,
				ArmySize = 8,
				SpawnCounter = 60,
				SpawnLeaders = 8,
				LeaderDesc = {
					{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3},
					{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3}
				},
				FreeArea = nil,
				RefillSoldiers = false,
				RandomizeSpawn = false,
				RandomizeSpawnPoint = false,
				DoNotRemoveIfDeadOrEmpty = false
			})
		else
			UnlimitedArmySpawnGenerator:New(NVBaseDefArmies[i],{
				Position = GetPosition("P2_Nephilim_TribalCamp"..i),
				ArmySize = 8,
				SpawnCounter = 60,
				SpawnLeaders = 8,
				LeaderDesc = {
					{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3},
					{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3}
				},
				Generator = "Nephilim_Tribal_CampTower"..i,
				FreeArea = nil,
				RefillSoldiers = false,
				RandomizeSpawn = false,
				RandomizeSpawnPoint = false,
				DoNotRemoveIfDeadOrEmpty = false
			})
		end
		
		NVBaseDefArmies[i].DefPos = GetPosition("P2_Nephilim_TribalCamp"..i)
		NVBaseDefArmies[i].CommandDelayer = 5
		NVBaseDefArmies[i].CampNumber = i
		NVBaseDefArmies[i]:AddCommandLuaFunc(BetterDefBehaviorForNV,true)
	end
	
----------------------------------------------------------------------------------------
	
	NVAttackAllyUAs = {}
	for i = 1,3,1 do
		UACounter = UACounter + 1
		NVAttackAllyUAs[i] = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 2800,
			AutoDestroyIfEmpty = false,
			TransitAttackMove = true,
			Formation = UnlimitedArmy.Formations.Chaotic,
			PrepDefense = false,
			DestroyBridges = false,
			LeaderFormation = nil,
			AIActive = true,
			DefendDoNotHelpHeroes = false,
			DoNotNormalizeSpeed = false,
			IgnoreFleeing = false,
			HiResJob = true
		},
		UACounter,
		UAMaxCounter
		)
	end
	NVAttackAllyUAs[1].SpawnPos = GetPosition("P2_Nephilim_TribalCamp1")
	NVAttackAllyUAs[1].Generator = "Nephilim_Tribal_CampTower1"
	NVAttackAllyUAs[2].SpawnPos = GetPosition("P2_Nephilim_TribalCamp2")
	NVAttackAllyUAs[2].Generator = "Nephilim_Tribal_CampTower2"
	NVAttackAllyUAs[3].SpawnPos = GetPosition("P2_Nephilim_TribalCamp5")
	NVAttackAllyUAs[3].Generator = "Nephilim_Tribal_CampTower5"
	for i = 1,3,1 do
		NVAttackAllyUAs[i].WaveCounter = 0
		if i == 3 then
			NVAttackAllyUAs[i].SpawnCounter = 180
			NVAttackAllyUAs[i].TimeToSpawn = 180
		else
			NVAttackAllyUAs[i].SpawnCounter = 240
			NVAttackAllyUAs[i].TimeToSpawn = 240
		end
		NVAttackAllyUAs[i].ArmySize = 6
		NVAttackAllyUAs[i]:AddCommandLuaFunc(HandleAttackAlly,true)
	end

----------------------------------------------------------------------------------------

	
	
end

function HandleAttackAlly(self)
	if not IsDead(self.Generator) then
		if self.SpawnCounter >= 0 then
			self.SpawnCounter = self.SpawnCounter - 1
		else
			self.SpawnCounter = self.TimeToSpawn
			local _spawnSwitch
			for i = 1, self.ArmySize, 1 do
				if _spawnSwitch then
					local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderBearman1, self.SpawnPos.X, self.SpawnPos.Y,0,2)
					for k = 1,16,1 do
						Logic.CreateEntity(Entities.CU_Evil_SoldierBearman1, self.SpawnPos.X, self.SpawnPos.Y, 0, 2 )
						Logic.LeaderGetOneSoldier( leaderID )	
					end
					self:AddLeader(leaderID)
				else
					--self:CreateLeaderForArmy(Entities.CU_Evil_LeaderSkirmisher1,16,self.SpawnPos,3)
					local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderSkirmisher1, self.SpawnPos.X, self.SpawnPos.Y,0,2)
					for k = 1,16,1 do
						Logic.CreateEntity(Entities.CU_Evil_SoldierSkirmisher1, self.SpawnPos.X, self.SpawnPos.Y, 0, 2 )
						Logic.LeaderGetOneSoldier( leaderID )	
					end
					self:AddLeader(leaderID)
				end
				_spawnSwitch = not _spawnSwitch
			end
			if self.WaveCounter <= 15 then
				self.WaveCounter = self.WaveCounter + 1
				if math.mod(self.WaveCounter,3) == 0 then
					self.ArmySize = self.ArmySize + 2
				end
			end
		end
	else
		if not self.Leaders[1] and not self.LeaderTransit[1] then
			self.AutoDestroyIfEmpty = true
			return false 
		end
	end
	if not self:IsIdle() then
		if self:GetStatus() == UnlimitedArmy.Status.Battle then
		local P1entities, Target1 = Logic.GetPlayerEntitiesInArea(1, nil, self:GetPosition().X, self:GetPosition().Y, 2800, 1, 10)
		local P8entities, Target2 = Logic.GetPlayerEntitiesInArea(8, nil, self:GetPosition().X, self:GetPosition().Y, 2800, 1, 10)
			if P1entities > 0 then
				return false, UnlimitedArmy.CreateCommandDirectAttack(Target1)
			end
			if P8entities > 0 then
				return false, UnlimitedArmy.CreateCommandDirectAttack(Target2)
			end
		end
		return false
	end
	if self:GetSize(true,false) >= 1 then
		self.SwitchAttackPoint = not self.SwitchAttackPoint
		if self.SwitchAttackPoint then
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("alkternateAttack"),false)
		else
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("PlayerRanged"),false)
		end
	else
		return true, UnlimitedArmy.CreateCommandMove(self.SpawnPos,false)
	end
end

function BetterDefBehaviorForNV(self)
	if self.CommandDelayer >= 0 then
			self.CommandDelayer = self.CommandDelayer -1
			return false
	else
			self.CommandDelayer = 5
	end
	for i = table.getn(self.Leaders),1,-1 do
		if Logic.LeaderGetNumberOfSoldiers(self.Leaders[i]) <= 0 then
			self:RemoveLeader(self.Leaders[i])
		end
	end
	if GetDistance(self:GetPosition(),self.DefPos) > 6500 then
		return false, UnlimitedArmy.CreateCommandFlee(self.DefPos)
	else
		return false, UnlimitedArmy.CreateCommandDefend(self.DefPos,i ~= 4 and 6500 or 4500 )
	end
	return false
end

function CreateNVAttackPlayerUAs(_base)
	GlobalBase = _base
	IslandSectors = {}
	ChangePlayer("PlayerHQ",1)
	
	IslandSectors[Logic.GetSector(GetID("HQ1EnemyPos"))] = GetPosition("HQ1EnemyPos")
	IslandSectors[Logic.GetSector(GetID("HQ2EnemyPos"))] = GetPosition("HQ2EnemyPos")
	IslandSectors[Logic.GetSector(GetID("HQ3EnemyPos"))] = GetPosition("HQ3EnemyPos")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp1"))] = GetPosition("P2_Nephilim_TribalCamp1")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp2"))] = GetPosition("P2_Nephilim_TribalCamp2")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp3"))] = GetPosition("P2_Nephilim_TribalCamp3")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp4"))] =  GetPosition("P2_Nephilim_TribalCamp4")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp5"))] =  GetPosition("P2_Nephilim_TribalCamp5")
	for o=1,3,1 do
		if GlobalBase ~= o then
			DestroyEntity(GetID("DZ"..o))
		end
	end

	local InitTable = {}
	
	InitTable[1] = {3,4,7,1}
	InitTable[2] = {4,3,6,1}
	InitTable[3] = {5,4,6,1}
	InitTable[4] = {3,4,6,1}
	InitTable[5] = {5,5,7,1}
	
	CreateNVBasesFromPlayerBases(GlobalBase)
	
	NVAttackPlayerUAs = {}
	for i = 1,5,1 do
		UACounter = UACounter + 1
		NVAttackPlayerUAs[i] = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 2800,
			AutoDestroyIfEmpty = false,
			TransitAttackMove = true,
			Formation = UnlimitedArmy.Formations.Chaotic,
			PrepDefense = false,
			DestroyBridges = false,
			LeaderFormation = nil,
			AIActive = true,
			DefendDoNotHelpHeroes = false,
			DoNotNormalizeSpeed = false,
			IgnoreFleeing = true,
			HiResJob = true
		},
		UACounter,
		UAMaxCounter
		)
		
		NVAttackPlayerUAs[i].SpawnCounter = (_base == 1 and 190) or (_base == 2 and 190) or (_base == 3 and 150)
		NVAttackPlayerUAs[i].TimeToSpawn = NVAttackPlayerUAs[i].SpawnCounter
		NVAttackPlayerUAs[i].NVBaseNumber = i
		
		NVAttackPlayerUAs[i].ArmySize = InitTable[i][_base]
		NVAttackPlayerUAs[i].currentWayPoint = 0
		NVAttackPlayerUAs[i].GiftReiterCounter = InitTable[i][4]
		NVAttackPlayerUAs[i].CheckedForEnemies = false
		
	end
	
	NVAttackPlayerUAs[1].SpawnPos = GetPosition("P2_Nephilim_TribalCamp1")
	NVAttackPlayerUAs[2].SpawnPos = GetPosition("P2_Nephilim_TribalCamp2")
	NVAttackPlayerUAs[3].SpawnPos = GetPosition("P2_Nephilim_TribalCamp3")
	NVAttackPlayerUAs[4].SpawnPos = GetPosition("P2_Nephilim_TribalCamp4")
	NVAttackPlayerUAs[5].SpawnPos = GetPosition("P2_Nephilim_TribalCamp5")
	
	NVAttackPlayerUAs[1].Generator = GetID("Nephilim_Tribal_CampTower1")
	NVAttackPlayerUAs[2].Generator = GetID("Nephilim_Tribal_CampTower2")
	NVAttackPlayerUAs[3].Generator = GetID("Nephilim_Tribal_CampTower3")
	NVAttackPlayerUAs[4].Generator = {GetID("Nephilim_Tribal_CampTower4"),GetID("Nephilim_Tribal_CampTower41"),GetID("Nephilim_Tribal_CampTower42"),GetID("Nephilim_Tribal_CampTower43"),GetID("Nephilim_Tribal_CampTower44"),GetID("Nephilim_Tribal_CampTower45")}
	NVAttackPlayerUAs[5].Generator = {GetID("Nephilim_Tribal_CampTower5"),
										GetID("Nephilim_Tribal_CampTower51"),
										GetID("Nephilim_Tribal_CampTower52"),
										GetID("Nephilim_Tribal_CampTower53"),
										GetID("Nephilim_Tribal_CampTower54"),
										GetID("Nephilim_Tribal_CampTower55"),
										GetID("Nephilim_Tribal_CampTower56"),
										GetID("Nephilim_Tribal_CampTower57"),
										GetID("Nephilim_Tribal_CampTower58"),
										GetID("Nephilim_Tribal_CampTower59"),
										GetID("Nephilim_Tribal_CampTower510"),
										GetID("Nephilim_Tribal_CampTower511"),
										GetID("Nephilim_Tribal_CampTower512")
										}
	SetupAttacksBase(_base)
	for i = 1,5,1 do
		NVAttackPlayerUAs[i]:AddCommandLuaFunc(BaseXAttackPlayerHQ,true)
	end
	
	Trigger.RequestTrigger(Events.LOGIC_EVENT_WEATHER_STATE_CHANGED,nil,"UpdateSectors",1,nil,nil)
	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"GeneratorDestroiedTrigger",1,nil,nil)
	
	StrengthCountdown = 0
	StartSimpleJob("StrengthIncrease")
end

function UpdateSectors()
	IslandSectors = {}
	
	IslandSectors[Logic.GetSector(GetID("HQ1EnemyPos"))] = GetPosition("HQ1EnemyPos")
	IslandSectors[Logic.GetSector(GetID("HQ2EnemyPos"))] = GetPosition("HQ2EnemyPos")
	IslandSectors[Logic.GetSector(GetID("HQ3EnemyPos"))] = GetPosition("HQ3EnemyPos")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp1"))] = GetPosition("P2_Nephilim_TribalCamp1")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp2"))] = GetPosition("P2_Nephilim_TribalCamp2")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp3"))] = GetPosition("P2_Nephilim_TribalCamp3")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp4"))] =  GetPosition("P2_Nephilim_TribalCamp4")
	IslandSectors[Logic.GetSector(GetID("P2_Nephilim_TribalCamp5"))] =  GetPosition("P2_Nephilim_TribalCamp5")
	--IslandSectors[Logic.GetSector(GetID("EndBaseLeftEntrace"))] = GetPosition("EndBaseLeftEntrace")
	--IslandSectors[Logic.GetSector(GetID("EndBaseMidEntrace"))] = GetPosition("EndBaseMidEntrace")
	--IslandSectors[Logic.GetSector(GetID("EndBaseRightEntrace"))] = GetPosition("EndBaseRightEntrace")
end

function StrengthIncrease()
	if Logic.GetWeatherState() ~= 1 then
		if GlobalBase == 1 then
			if StrengthCountdown == 2100 then
				NVAttackPlayerUAs[1].ArmySize = NVAttackPlayerUAs[1].ArmySize + 3
				NVAttackPlayerUAs[1].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[2].ArmySize = NVAttackPlayerUAs[2].ArmySize + 2
				NVAttackPlayerUAs[2].GiftReiterCounter = NVAttackPlayerUAs[2].GiftReiterCounter + 1
				NVAttackPlayerUAs[3].ArmySize = NVAttackPlayerUAs[3].ArmySize + 3
				NVAttackPlayerUAs[3].GiftReiterCounter = NVAttackPlayerUAs[3].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].ArmySize = NVAttackPlayerUAs[4].ArmySize + 3
				NVAttackPlayerUAs[4].GiftReiterCounter = NVAttackPlayerUAs[4].GiftReiterCounter + 1
				NVAttackPlayerUAs[5].ArmySize = NVAttackPlayerUAs[5].ArmySize + 3
				NVAttackPlayerUAs[5].GiftReiterCounter = NVAttackPlayerUAs[5].GiftReiterCounter + 1
			end
			if StrengthCountdown == 3300 then
				NVAttackPlayerUAs[1].ArmySize = NVAttackPlayerUAs[1].ArmySize + 4
				NVAttackPlayerUAs[1].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[2].ArmySize = NVAttackPlayerUAs[2].ArmySize + 3
				NVAttackPlayerUAs[2].GiftReiterCounter = NVAttackPlayerUAs[2].GiftReiterCounter + 1
				NVAttackPlayerUAs[3].ArmySize = NVAttackPlayerUAs[3].ArmySize + 4
				NVAttackPlayerUAs[3].GiftReiterCounter = NVAttackPlayerUAs[3].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].ArmySize = NVAttackPlayerUAs[4].ArmySize + 4
				NVAttackPlayerUAs[4].GiftReiterCounter = NVAttackPlayerUAs[4].GiftReiterCounter + 1
				NVAttackPlayerUAs[5].ArmySize = NVAttackPlayerUAs[5].ArmySize + 4
				NVAttackPlayerUAs[5].GiftReiterCounter = NVAttackPlayerUAs[5].GiftReiterCounter + 1
				return true
			end
		elseif GlobalBase == 2 then
			if StrengthCountdown == 2100 then
				NVAttackPlayerUAs[1].ArmySize = NVAttackPlayerUAs[1].ArmySize + 2
				NVAttackPlayerUAs[1].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[2].ArmySize = NVAttackPlayerUAs[2].ArmySize + 3
				NVAttackPlayerUAs[2].GiftReiterCounter = NVAttackPlayerUAs[2].GiftReiterCounter + 1
				NVAttackPlayerUAs[3].ArmySize = NVAttackPlayerUAs[3].ArmySize + 2
				NVAttackPlayerUAs[3].GiftReiterCounter = NVAttackPlayerUAs[3].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].ArmySize = NVAttackPlayerUAs[4].ArmySize + 2
				NVAttackPlayerUAs[4].GiftReiterCounter = NVAttackPlayerUAs[4].GiftReiterCounter + 1
				NVAttackPlayerUAs[5].ArmySize = NVAttackPlayerUAs[5].ArmySize + 3
				NVAttackPlayerUAs[5].GiftReiterCounter = NVAttackPlayerUAs[5].GiftReiterCounter + 1
			end
			if StrengthCountdown == 3300 then
				NVAttackPlayerUAs[1].ArmySize = NVAttackPlayerUAs[1].ArmySize + 3
				NVAttackPlayerUAs[1].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[2].ArmySize = NVAttackPlayerUAs[2].ArmySize + 4
				NVAttackPlayerUAs[2].GiftReiterCounter = NVAttackPlayerUAs[2].GiftReiterCounter + 1
				NVAttackPlayerUAs[3].ArmySize = NVAttackPlayerUAs[3].ArmySize + 3
				NVAttackPlayerUAs[3].GiftReiterCounter = NVAttackPlayerUAs[3].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].ArmySize = NVAttackPlayerUAs[4].ArmySize + 3
				NVAttackPlayerUAs[4].GiftReiterCounter = NVAttackPlayerUAs[4].GiftReiterCounter + 1
				NVAttackPlayerUAs[5].ArmySize = NVAttackPlayerUAs[5].ArmySize + 4
				NVAttackPlayerUAs[5].GiftReiterCounter = NVAttackPlayerUAs[5].GiftReiterCounter + 1
				return true
			end
			
		else
			if StrengthCountdown == 1500 then
				NVAttackPlayerUAs[1].ArmySize = NVAttackPlayerUAs[1].ArmySize + 3
				NVAttackPlayerUAs[1].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[2].ArmySize = NVAttackPlayerUAs[2].ArmySize + 2
				NVAttackPlayerUAs[2].GiftReiterCounter = NVAttackPlayerUAs[2].GiftReiterCounter + 1
				NVAttackPlayerUAs[3].ArmySize = NVAttackPlayerUAs[3].ArmySize + 2
				NVAttackPlayerUAs[3].GiftReiterCounter = NVAttackPlayerUAs[3].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].ArmySize = NVAttackPlayerUAs[4].ArmySize + 2
				NVAttackPlayerUAs[4].GiftReiterCounter = NVAttackPlayerUAs[4].GiftReiterCounter + 1
				NVAttackPlayerUAs[5].ArmySize = NVAttackPlayerUAs[5].ArmySize + 3
				NVAttackPlayerUAs[5].GiftReiterCounter = NVAttackPlayerUAs[5].GiftReiterCounter + 1
			end
			if StrengthCountdown == 2400 then
				NVAttackPlayerUAs[1].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[2].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[3].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[5].GiftReiterCounter = NVAttackPlayerUAs[1].GiftReiterCounter + 1
				NVAttackPlayerUAs[4].ArmySize = NVAttackPlayerUAs[4].ArmySize + 4
				NVAttackPlayerUAs[5].ArmySize = NVAttackPlayerUAs[5].ArmySize + 4
			end
			if StrengthCountdown == 2700 then
				NVAttackPlayerUAs[1].ArmySize = NVAttackPlayerUAs[1].ArmySize + 2
				NVAttackPlayerUAs[2].ArmySize = NVAttackPlayerUAs[2].ArmySize + 4
				NVAttackPlayerUAs[3].ArmySize = NVAttackPlayerUAs[3].ArmySize + 2
				return true
			end
		end
	
	StrengthCountdown = StrengthCountdown + 1
	end
	return false
end

function GeneratorDestroiedTrigger()
	local _entID = Event.GetEntityID()
	local _entName = Logic.GetEntityName(_entID)
	if _entName ~= nil then
		local _substring = string.sub(Logic.GetEntityName(_entID),1,25)
		if _substring == "Nephilim_Tribal_CampTower" then
			local _CampNumber = tonumber(string.sub(Logic.GetEntityName(_entID),26,26))
			if _CampNumber >= 4 then
				--local _genNumber = tonumber(string.sub(Logic.GetEntityName(_entID),27,28))
				for _index,_value in ipairs(NVAttackPlayerUAs[_CampNumber].Generator) do
					if _value == _entID then
						 table.remove(NVAttackPlayerUAs[_CampNumber].Generator,_index)
						 break
					end
				end
				
				if table.getn(NVAttackPlayerUAs[_CampNumber].Generator) == 0 then
					NVAttackPlayerUAs[_CampNumber].NoGen = true
					StartSpecialAttack(_CampNumber)
				end
			else
				NVAttackPlayerUAs[_CampNumber].Generator = nil
				NVAttackPlayerUAs[_CampNumber].NoGen = true
				StartSpecialAttack(_CampNumber)
			end
			
		end
	end
	return false
end

function StartSpecialAttack(_CampDestroied)
	StartWinter(600)
	for i = 1,5,1 do
		if i ~= _CampDestroied then
			if not NVAttackPlayerUAs[i].NoGen then
				--GlobalBase
				local ToSpawn
				if i <= 3 then
					ToSpawn = 8
				else
					ToSpawn = 8
				end
				
				local _spawnSwitch
				for j = 1,ToSpawn, 1 do
					if _spawnSwitch then
						local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderBearman1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y,0,2)
						for k = 1,16,1 do
							Logic.CreateEntity(Entities.CU_Evil_SoldierBearman1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y, 0, 2 )
							Logic.LeaderGetOneSoldier( leaderID )	
						end
						NVAttackPlayerUAs[i]:AddLeader(leaderID)
					else
						local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderSkirmisher1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y,0,2)
						for k = 1,16,1 do
							Logic.CreateEntity(Entities.CU_Evil_SoldierSkirmisher1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y, 0, 2 )
							Logic.LeaderGetOneSoldier( leaderID )	
						end
						NVAttackPlayerUAs[i]:AddLeader(leaderID)
					end
					_spawnSwitch = not _spawnSwitch
				end
		
				for j = 1,1,1 do
					local trooptable = {ID = AI.Entity_CreateFormation(2, Entities.PU_LeaderHeavyCavalry2, nil, 0, NVAttackPlayerUAs[i].SpawnPos.X,NVAttackPlayerUAs[i].SpawnPos.Y, nil, nil, 3,0),PoisonCounter = 2}
					NVAttackPlayerUAs[i]:AddLeader(trooptable.ID)
					table.insert(giftreiter,trooptable)
				end
				
			end
		end
	end
	StartSimpleJob("DelayNextSpawn", _CampDestroied)
end

function DelayNextSpawn(_CampDestroied)
	if Counter.Tick2("WaveDelay",2) then
		for i = 1,5,1 do
		if i ~= _CampDestroied then
			if not NVAttackPlayerUAs[i].NoGen then
				--GlobalBase
				local ToSpawn
				if i <= 3 then
					ToSpawn = 8
				else
					ToSpawn = 8
				end
				
				local _spawnSwitch
				for j = 1,ToSpawn, 1 do
					if _spawnSwitch then
						local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderBearman1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y,0,2)
						for k = 1,16,1 do
							Logic.CreateEntity(Entities.CU_Evil_SoldierBearman1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y, 0, 2 )
							Logic.LeaderGetOneSoldier( leaderID )	
						end
						NVAttackPlayerUAs[i]:AddLeader(leaderID)
					else
						local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderSkirmisher1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y,0,2)
						for k = 1,16,1 do
							Logic.CreateEntity(Entities.CU_Evil_SoldierSkirmisher1, NVAttackPlayerUAs[i].SpawnPos.X, NVAttackPlayerUAs[i].SpawnPos.Y, 0, 2 )
							Logic.LeaderGetOneSoldier( leaderID )	
						end
						NVAttackPlayerUAs[i]:AddLeader(leaderID)
					end
					_spawnSwitch = not _spawnSwitch
				end
		
				for j = 1,1,1 do
					local trooptable = {ID = AI.Entity_CreateFormation(2, Entities.PU_LeaderHeavyCavalry2, nil, 0, NVAttackPlayerUAs[i].SpawnPos.X,NVAttackPlayerUAs[i].SpawnPos.Y, nil, nil, 3,0),PoisonCounter = 2}
					NVAttackPlayerUAs[i]:AddLeader(trooptable.ID)
					table.insert(giftreiter,trooptable)
				end
				
			end
		end
	end
	return true
	end
	return false
end 

function UASpawnTroops(self)
	if self.NoGen == true then
		if self:IsDead() == 1 then
			self.AutoDestroyIfEmpty = true
			return true
		end
	end
	if self:GetSize(true,false) > math.floor((self.ArmySize/2)+0.5) then
		return true
	end
	if self.SpawnCounter >= 0 then
		self.SpawnCounter = self.SpawnCounter - 1
	else
		self.SpawnCounter = self.TimeToSpawn
		local _spawnSwitch
		for i = 1, self.ArmySize, 1 do
			if _spawnSwitch then
				local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderBearman1, self.SpawnPos.X, self.SpawnPos.Y,0,2)
				for k = 1,16,1 do
					Logic.CreateEntity(Entities.CU_Evil_SoldierBearman1, self.SpawnPos.X, self.SpawnPos.Y, 0, 2 )
					Logic.LeaderGetOneSoldier( leaderID )	
				end
				self:AddLeader(leaderID)
			else
				local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderSkirmisher1, self.SpawnPos.X, self.SpawnPos.Y,0,2)
				for k = 1,16,1 do
					Logic.CreateEntity(Entities.CU_Evil_SoldierSkirmisher1, self.SpawnPos.X, self.SpawnPos.Y, 0, 2 )
					Logic.LeaderGetOneSoldier( leaderID )	
				end
				self:AddLeader(leaderID)
			end
			_spawnSwitch = not _spawnSwitch
		end
		
		for i = 1,self.GiftReiterCounter,1 do
			local trooptable = {ID = AI.Entity_CreateFormation(2, Entities.PU_LeaderHeavyCavalry2, nil, 0, self.SpawnPos.X,self.SpawnPos.Y, nil, nil, 3,0),PoisonCounter = 2}
			self:AddLeader(trooptable.ID)
			table.insert(giftreiter,trooptable)
		end
	end
end

function SetupAttacksBase(_base)
	if _base == 1 then
		NVAttackPlayerUAs[1].Waypoints = {GetPosition("Base1MoorWaypoint"),GetPosition("AtBase1BridgeWayPoint"),GetPosition("InBase1Waypoint"),GetPosition("HQ1EnemyPos")} 
		NVAttackPlayerUAs[2].Waypoints = {GetPosition("Base1LowerPoint"),GetPosition("HQ1EnemyPos")}
		NVAttackPlayerUAs[3].Waypoints = {GetPosition("HQ3EnemyPos"),GetPosition("HQ2EnemyPos"),GetPosition("ArmyMovePos2"),GetPosition("HQ1EnemyPos")}
		NVAttackPlayerUAs[4].Waypoints = {{GetPosition("Base1NorthWayPoint"),GetPosition("InBase1Waypoint")},GetPosition("HQ1EnemyPos")}
		NVAttackPlayerUAs[5].Waypoints = {GetPosition("HQ3LowerPoint"),GetPosition("HQ2EnemyPos"),{GetPosition("ArmyMovePos2"),GetPosition("Base1LowerPoint")},GetPosition("HQ1EnemyPos")}
	elseif _base == 2 then
		NVAttackPlayerUAs[1].Waypoints = {GetPosition("HQ1EnemyPos"),GetPosition("ArmyMovePos2"),GetPosition("HQ2EnemyPos")}
		NVAttackPlayerUAs[2].Waypoints = {{GetPosition("HQ2LowerPoint"),GetPosition("HQ2LowerPoint2")},GetPosition("HQ2EnemyPos")}
		NVAttackPlayerUAs[3].Waypoints = {GetPosition("HQ3EnemyPos"),GetPosition("HQ3WestEntrance"),GetPosition("ArmyMovePos3_3"),GetPosition("HQ2EnemyPos")}
		NVAttackPlayerUAs[4].Waypoints = {GetPosition("Base4HQ2Waypoint"),GetPosition("HQ2EnemyPos")}
		NVAttackPlayerUAs[5].Waypoints = {GetPosition("HQ3LowerPoint"),GetPosition("HQ2EnemyPos")}
	else
		NVAttackPlayerUAs[1].Waypoints = {GetPosition("HQ1EnemyPos"),GetPosition("ArmyMovePos2"),GetPosition("HQ2EnemyPos"),GetPosition("HQ3EnemyPos")}
		NVAttackPlayerUAs[2].Waypoints = {GetPosition("HQ2EnemyPos"),GetPosition("HQ3LowerPoint"),GetPosition("HQ3EnemyPos")}
		NVAttackPlayerUAs[3].Waypoints = {GetPosition("HQ3EnemyPos")}
		NVAttackPlayerUAs[4].Waypoints = {GetPosition("Base4HQ2Waypoint"),GetPosition("Base4SplitWayPoint"),{GetPosition("HQ3WestEntrance"),GetPosition("HQ3NorthEntrance")},GetPosition("HQ3EnemyPos")}
		NVAttackPlayerUAs[5].Waypoints = {GetPosition("HQ3LowerPoint"),GetPosition("HQ3EnemyPos")}
	end
end

function BaseXAttackPlayerHQ(self)
	for i = table.getn(self.Leaders),1,-1 do
		if Logic.GetEntityType(self.Leaders[i]) ~= Entities.PU_LeaderHeavyCavalry2 then
			if Logic.LeaderGetNumberOfSoldiers(self.Leaders[i]) <= 0 then
				self:RemoveLeader(self.Leaders[i])
			end
		end
	end
	if Logic.GetWeatherState() ~= 3 then
		if self:IsIdle() then
			if Logic.GetSector(self.Leaders[1]) ~= Logic.GetSector(self.SpawnPos) then
				local OnIsland = IslandSectors[Logic.GetSector(self.Leaders[1])]
				if OnIsland then
					return false,UnlimitedArmy.CreateCommandDefend(OnIsland,10000) 
				end
			else
				return false, UnlimitedArmy.CreateCommandDefend(self.SpawnPos,6000) 
			end
		end
	end
	UASpawnTroops(self)
	if self:IsIdle() then
		if self:GetSize(true,false) >= 1 then
			if not self.CheckedForEnemies and self.currentWayPoint ~= 0 then
				self.CheckedForEnemies = true
				return true, UnlimitedArmy.CreateCommandAttackNearestTarget(((GlobalBase == 1 and self.NVBaseNumber == 1) and 5000) or 15000 )
			end
			self.CheckedForEnemies = false
			self.currentWayPoint = self.currentWayPoint + 1
			if self.Waypoints[self.currentWayPoint] then
				if self.Waypoints[self.currentWayPoint].X then
					return true, UnlimitedArmy.CreateCommandMove(self.Waypoints[self.currentWayPoint])
				else
					return true, UnlimitedArmy.CreateCommandMove(self.Waypoints[self.currentWayPoint][math.random(1,2)])
				end
			else
				self.currentWayPoint = 0
				return true, UnlimitedArmy.CreateCommandMove(self.SpawnPos)
			end
		else
			self.currentWayPoint = 0
			return true, UnlimitedArmy.CreateCommandMove(self.SpawnPos)
		end
	end
	return false	
end

function CreateNVBasesFromPlayerBases(_base)
	DestroyNPCHQ1()
	DestroyNPCHQ2()
	DestroyNPCHQ3()
	ClearOtherBases()
	for i = 1,3,1 do
		if i ~= _base then
			mcbPacker.require("NV_Base"..i)
		end
	end
	CreatePlayerHQNVUAs(_base)
end

function ClearOtherBases()
	local _TableWithEntities = {Logic.GetPlayerEntities(5, _type, 48)}
	repeat
		while _TableWithEntities[1] > 0 do
			if GlobalBase ~= 3 then
				Logic.DestroyEntity(table.remove(_TableWithEntities,_TableWithEntities[1]+1))
			else
				local _entID = table.remove(_TableWithEntities,_TableWithEntities[1]+1)
				if Logic.IsEntityInCategory(_entID, EntityCategories.Wall) == 1 then
					Logic.ChangeEntityPlayerID(_entID, 1)
				else
					Logic.DestroyEntity(_entID)
				end
			end
			_TableWithEntities[1] = _TableWithEntities[1] - 1
		end
		_TableWithEntities = {Logic.GetPlayerEntities(5, _type, 48)}
	until _TableWithEntities[1] <= 0
end

function CreatePlayerHQNVUAs(_base)
	for i = 1,3,1 do
		if i ~= _base then
			UACounter = UACounter + 1
			_G["HQ"..i.."NVDefUA"] = LazyUnlimitedArmy:New({
				Player = 2,
				Area = 3500,
				AutoDestroyIfEmpty = true,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				PrepDefense = false,
				DestroyBridges = false,
				LeaderFormation = nil,
				AIActive = true,
				DefendDoNotHelpHeroes = false,
				DoNotNormalizeSpeed = false,
				IgnoreFleeing = true,
				HiResJob = true
			},
			UACounter,
			UAMaxCounter
			)
			
			local _spawn = {}
			_spawn[1] =  GetPosition("HQ"..i.."BaseNVSpawn1")
			_spawn[1].Generator = "HQ"..i.."BaseNVSpawnGen1"
			_spawn[2] =  GetPosition("HQ"..i.."BaseNVSpawn2")
			_spawn[2].Generator = "HQ"..i.."BaseNVSpawnGen2"
			_G["HQ"..i.."NCDefUASpawner"] = UnlimitedArmySpawnGenerator:New(_G["HQ"..i.."NVDefUA"],{
					Position = _spawn,
					ArmySize = 8,
					SpawnCounter = 60,
					SpawnLeaders = 8,
					LeaderDesc = {
						{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3},
						{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3}
					},
					--Generator = "Nephilim_Tribal_CampTower"..i,
					FreeArea = nil,
					RefillSoldiers = false,
					RandomizeSpawn = false,
					RandomizeSpawnPoint = false,
					DoNotRemoveIfDeadOrEmpty = false
				})
			if i == 1 then
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ1BaseNVSpawn1"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ1BaseNVSpawn2"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ1VCDefPoint"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
			elseif i == 2 then
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ2BaseNVSpawn1"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ2BaseNVSpawn2"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("Base2NVStonePoint"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
			else
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ3BaseNVSpawn2"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("ArmyMovePos4_4"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ3BaseNVSpawn1"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("ArmyMovePos4_3"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("HQ3LowerPoint"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
				_G["HQ"..i.."NVDefUA"]:AddCommandMove(GetPosition("ArmyMovePos4_3"),true)
				_G["HQ"..i.."NVDefUA"]:AddCommandWaitForIdle(true)
			end
		end
	end
end